' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Partial Class ShoppingCartView
  Inherits System.Web.UI.UserControl

  Private _isReadOnly As Boolean = False
  Dim priceTotal As Decimal = 0
  Dim quantityTotal As Integer = 0

  Public Event CartUpdated As EventHandler

  '''' <summary>
  '''' Uruchamia si przy aktualizacji wiersza w kontrolce GridView. Wyzwala zdarzenie, ktre moe by obsuone przez stron zawierajc t kontrolk uytkownika.
  '''' </summary>
  Protected Sub GridView1_RowUpdated(ByVal sender As Object, _
      ByVal e As System.Web.UI.WebControls.GridViewUpdatedEventArgs) _
      Handles GridView1.RowUpdated

    RaiseEvent CartUpdated(sender, New System.EventArgs())
  End Sub

  ''' <summary>
  ''' Uruchamia si przy usuwaniu wiersza z GridView. Wyzwala zdarzenie, ktre moe by obsuone przez stron zawierajc t kontrolk uytkownika.
  ''' </summary>
  Protected Sub GridView1_RowDeleted(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewDeletedEventArgs) Handles GridView1.RowDeleted
    RaiseEvent CartUpdated(sender, New System.EventArgs())
  End Sub

  Public Property [ReadOnly]() As Boolean
    Get
      Return _isReadOnly
    End Get
    Set(ByVal value As Boolean)
      _isReadOnly = value
    End Set
  End Property

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    If _isReadOnly Then
      GridView1.Columns(5).Visible = False
      GridView1.Columns(6).Visible = False
    End If
  End Sub

  Protected Sub GridView1_RowDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles GridView1.RowDataBound
    Select Case e.Row.RowType
      Case DataControlRowType.DataRow
        ' Dla kadej pozycji w rdle danych pobierz ilo i sum czciow i zapisz je w
        ' zmiennych prywatnych priceTotal i quantityTotal. Po dowizaniu stopki kontrolki do danych,
        ' te sumy s do niej dodawane.
        priceTotal += Convert.ToDecimal(DataBinder.Eval(e.Row.DataItem, "SubTotal"))
        quantityTotal += Convert.ToInt32(DataBinder.Eval(e.Row.DataItem, "Quantity"))
      Case DataControlRowType.Footer
        e.Row.Cells(0).Text = "Suma:"
        ' Wywietl sum czciow danej pozycji oraz sum zamwienia w stopce
        e.Row.Cells(2).Text = quantityTotal.ToString()
        e.Row.Cells(4).Text = priceTotal.ToString("c")

        e.Row.Cells(2).HorizontalAlign = HorizontalAlign.Right
        e.Row.Cells(4).HorizontalAlign = HorizontalAlign.Right
    End Select
  End Sub

  Protected Sub lstQuantity_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs)
    GridView1.UpdateRow(GridView1.EditIndex, False)
    GridView1.EditIndex = -1
  End Sub

  Protected Sub odsShoppingCart_Updating(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.ObjectDataSourceMethodEventArgs) Handles odsShoppingCart.Updating
    ' Pobierz identyfikator i now ilo z formularza i przypisz je do InputParams metody Update.
    ' Te dwa parametry bd przesane do metody aktualizujcej w metodzie UpdateProductInCart klasy ShopManager.
    e.InputParameters("Id") = _
        New Guid(GridView1.DataKeys(GridView1.EditIndex).Value.ToString())
    e.InputParameters("newQuantity") = Convert.ToInt32( _
        CType(GridView1.Rows(GridView1.EditIndex).FindControl("lstQuantity"), _
        DropDownList).SelectedValue)
  End Sub
End Class
